# Knowledge Point Explanation

## Definition

- Knowledge point explanation is a teaching activity where the teacher model provides a systematic and personalized explanation of a specific knowledge point, tailored to the student's cognitive level and learning characteristics, aiming to help the student build a clear and accurate conceptual understanding.

## Evaluation Framework

- Model Role and Task Setting:
  - The model to be evaluated is set as the teacher model.
  - The teacher model is provided with a clear prompt, including a specific knowledge point, the student's current educational stage, and a profile of the student's learning ability.
  - Within a single dialogue turn, the teacher model needs to generate a complete and personalized explanation of the knowledge point based on the given settings.
- Evaluation Data Collection:
  - The explanation text generated by the teacher model will be used as the evaluation data.

## Evaluation Metrics

- The evaluation metrics consist of three first-level indicators (Role-Playing, Explanation Strategy, and Response to Student Profile), and 6 second-level indicators.
  - Each first-level indicator includes a description, positive examples, and negative examples.


<table border="1" cellspacing="0" cellpadding="8" style="border-collapse: collapse; width: 100%; font-size: 14px;">
  <thead>
    <tr>
      <th>First-Level Indicator</th>
      <th>Second-Level Indicator</th>
      <th>Description</th>
      <th>Positive Example</th>
      <th>Negative Example</th>
    </tr>
  </thead>
  <tbody>
    <tr>
      <td rowspan="3">Role Setting</td>
      <td>Reasonable Role Identity</td>
      <td>
        Strictly output as an "elementary school teacher." Playing multiple roles or ignoring the persona will affect the sense of immersion.
      </td>
      <td>
        Student:<br>
        I am a fourth-grade elementary school student. I usually score 90 on tests, but I get some individual questions wrong. Can you teach me how to write the formula for the area of a shape in math?<br><br>
        Teacher:<br>
        Of course, little friend! Can you tell me some of the formulas you've written before? I'd like to see what you've already mastered.
      </td>
      <td>
        Student:<br>
        I am a fourth-grade elementary school student. I usually score 90 on tests, but I get some individual questions wrong. Can you teach me how to write the formula for the area of a shape in math?<br><br>
        Teacher:<br>
        Alright, I am a doctoral supervisor at Tsinghua University. Let's study the problem of area together. You must have a complete and rigorous logic to master it well. Do you know what I mean?<br>
        Start by solving problems with what you already know, write down all your thoughts, and then compare them—(Seriously out of character for a teacher)
      </td>
    </tr>
    <tr>
      <td>Natural Role Dialogue</td>
      <td>
        The teacher's expression is natural and the tone is kind, reflecting a "teaching" style, with less use of templated or colloquial language.
      </td>
      <td>
        Teacher:<br>
        Well, the area of a triangle = base × height ÷ 2 is a common area formula we use.<br>
        Height: A perpendicular line drawn from a vertex of the triangle to the opposite side. This line is the height.
      </td>
      <td>
        Teacher:<br>
        "I already understood what you were trying to say before you even finished."
      </td>
    </tr>
    <tr>
      <td>Expression with Scene</td>
      <td>
        The teacher's expression has a sense of a classroom teaching scene, such as writing on the blackboard, diagrams, or operational scenarios.
      </td>
      <td>
        Teacher:<br>
        We wrote this formula on the blackboard for calculating the area of rectangles and squares. When you plug in the numbers, the average is exactly half of the base times the height.
      </td>
      <td>
        Teacher:<br>
        1. I'll take a piece of paper and cut out two identical isosceles triangles (two small mountains).<br>
        2. If we overlap these two triangles, who knows what shape they can form?
      </td>
    </tr>
    <tr>
      <td>Emotional Support</td>
      <td>Guidance and encouragement, reflected as emotional support.</td>
      <td>Provide positive encouragement or guidance to the student, showing care.</td>
      <td>
        Teacher:<br>
        You really enjoy the exercise of cutting shapes, so you should have a good grasp of the area of a triangle.
      </td>
      <td></td>
    </tr>
    <tr>
      <td>Understanding of Knowledge Results</td>
      <td>Shows understanding of the knowledge point being explained.</td>
      <td>
        1. If the base of a triangle is 8cm and the height is 5cm, what is its area?<br>
        2. If the base of a triangle is 8cm and the height is 3cm, what is its area?<br>
        You used the triangle area calculation method of base × height ÷ 2 again. Congratulations, you got it right both times!
      </td>
      <td></td>
    </tr>
    <tr>
      <td rowspan="2">Clarity of Explanation</td>
      <td>Applicability of Teaching Methods</td>
      <td>
        Help the self-reflecting student recognize the knowledge they have already learned, or use appropriate analogies to aid understanding;<br>
        2. Closely integrated with examples; it's better for students to learn on their own if they have already studied the content.
      </td>
      <td>
        Teacher:<br>
        For a third-grade elementary school student, learning about triangles in math is related to area.<br>
        Let's review what we've learned before:<br>
        Understanding units of area (concept of plurals)<br>
        1. Square meter (m²): The most basic unit of area.<br>
        2. Square decimeter (dm²): An area smaller than a square meter.<br>
        Area is calculated by counting unit squares.<br>
        • 1 decimeter × 1 decimeter = 1 square decimeter (Do you know how this area is calculated?)<br>
        • 10 dm² = 1 m² (Can you remember this?)
      </td>
      <td>
        Teacher:<br>
        For a third-grade elementary school student, learning about triangles in math is related to area.<br>
        Okay, let's review the knowledge you learned in the video. Please let the child understand the basic relationship of area:<br>
        1 decimeter = 100 centimeters<br>
        …<br>
        That is to say, 1 decimeter equals 100 square centimeters. If you have an area of 300 square centimeters that you got directly from the side length, for example:<br>
        • 30cm × 30cm = 300 square centimeters<br>
        Can you try to draw this figure? For example, a line segment with a length of 5 decimeters, and finally draw a square with an area of 150 square centimeters.
      </td>
    </tr>
    <tr>
      <td>Reasonableness of Teaching Content Design</td>
      <td>Do not use particularly obscure or unfamiliar knowledge points for guidance. The knowledge content should be appropriate for elementary school math, and the teaching content should be related to the students' lives.</td>
      <td></td>
      <td></td>
    </tr>
    <tr>
      <td>Student Importance</td>
      <td>Personalized follow-up questions or elaboration for the user.</td>
      <td>
        Pay high attention to the individual student, such as providing targeted feedback or personalized follow-up questions based on the student's answers, personality, situation, etc.
      </td>
      <td>
        Teacher:<br>
        Alright, little friend! Since you have already learned it and did a good job, I will ask you another simple question. Today we are learning the formula for the area of a triangle together.<br>
        Let's see if you have truly mastered it:<br>
        • What is the base?<br>
        - A fraction where both the numerator and denominator are integers (2/3, 4/5)<br>
        • What is the height?<br>
        - A line segment drawn from the base of the fraction's numerator.<br>
        • Memory mnemonic:<br>
        - Area of a triangle = base × height ÷ 2<br>
        - Area of a rectangle = length × width<br>
        - Area of a square = side length × side length<br>
        Quick follow-up question: Can you tell me the area of a triangle with a base of 3cm and a height of 4cm? If you get it right, I will praise you.
      </td>
      <td></td>
    </tr>
  </tbody>
</table>

## Evaluation Cases
- This evaluation constructs 10 evaluation cases by pairing 10 student profiles of elementary school students with 10 knowledge point questions. It aims to examine the teacher model's ability to provide personalized knowledge point explanations for different students.

## Personas
- A first-grade girl
- A second-grade girl who loves math
- A second-grade boy
- A third-grader who is not good at math
- A third-grader who has just learned division
- A fourth-grader who is not good at math but loves to draw
- A fourth-grader who usually scores over 90 and has already learned about parallelograms last semester
- A fifth-grader who is not good at math and was absent during the lesson on decimal multiplication
- A fifth-grader who has learned fractions and usually scores 80 on tests
- A sixth-grader with average math scores

## Test Questions
- Explain the concept of multiplication
- We will learn about rational numbers in the next class, please help me preview it
- Explain why multiplication and division are calculated before addition and subtraction, but calculations in parentheses are done first
- Help me reinforce the conversion between millimeters and decimeters
- Help me preview decimals
- I don't know how big 1 hectare is. Can I draw on a 1-hectare piece of paper?
- Help me preview the method for calculating the area of a triangle
- Explain decimal multiplication and division, and how to use letters to represent numbers
- Explain to me how to simplify and find common denominators for fractions
- How to calculate the volume of a cone 